(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 4.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     26350,        904]*)
(*NotebookOutlinePosition[     27281,        935]*)
(*  CellTagsIndexPosition[     27237,        931]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[{
  "Formal Series Solution\n",
  StyleBox["Regular Singular Point, Case I",
    FontSize->14],
  ""
}], "Subtitle",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Modified 4/12/98 to be compatible with V 3.0 C. C. Ross
Modified 4/9/2000 to be compatible with V4.0 C. C. Ross
Minor modification to Sum (HoldAll) 4/9/2001 C. C. Ross\
\>", "Text",
  FontSize->10],

Cell[TextData[{
  "This notebook takes advantage of the fact that Sum does not evaluate when \
its terms are unknown. We can therefore perform manipulations on the \
unevaluated arguments. These manipulations parallel those you would perform \
in order to find a series solution manually.\n\nThe ",
  StyleBox["Yellow Boxed",
    FontWeight->"Bold"],
  " cells require special manual attention. ",
  StyleBox["These are places where you can direct the progress of the \
solution",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  ". \n\n",
  StyleBox["Use Shift-Enter to select the next executable cell, and \
Shift-Enter again to execute it.",
    FontVariations->{"Underline"->True}]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["The Differential Operator & Assumed solution, y[x]", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Execute each of the following cells in order. You will have to decide on \
the form of the solution. When Log series are necessary, you can decide on \
the highest power after trying a simple power series solution. Count the \
linearly independent power series solutions that you get. Then decide whether \
or not Log series are needed. \n",
  StyleBox["When asked to evaluate the initialization cells, respond 'Yes'.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]]
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["The Operator and its standard form", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Define your differential operator",
    FontWeight->"Bold"],
  " in the boxed cell below. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{\(Op[x_, v_]\), "=", 
      RowBox[{
        RowBox[{"3", \(x\^2\), " ", 
          RowBox[{
            SuperscriptBox["v", "\[DoublePrime]",
              MultilineFunction->None], "[", "x", "]"}]}], "+", 
        RowBox[{\((x\^2 - x)\), " ", 
          RowBox[{
            SuperscriptBox["v", "\[Prime]",
              MultilineFunction->None], "[", "x", "]"}]}], 
        "+", \(\((1 + 2  x)\)\ v[x]\)}]}]], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.97586, 1, 0.710002]],

Cell[BoxData[
    RowBox[{\(\((1 + 2\ x)\)\ v[x]\), "+", 
      RowBox[{\((\(-x\) + x\^2)\), " ", 
        RowBox[{
          SuperscriptBox["v", "\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}], "+", 
      RowBox[{"3", " ", \(x\^2\), " ", 
        RowBox[{
          SuperscriptBox["v", "\[Prime]\[Prime]",
            MultilineFunction->None], "[", "x", "]"}]}]}]], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["For this notebook to work correctly",
    FontWeight->"Bold"],
  ", the result of executing the next cell MUST be \n             ",
  StyleBox["{ReadProtected}",
    FontFamily->"Courier"],
  ".\n If not, ",
  StyleBox["re-execute the first cell in the Implementation section below and \
check the next cell again",
    FontVariations->{"Underline"->True}],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(FixSum\), "\[IndentingNewLine]", 
    \(Attributes[Sum]\)}], "Input"],

Cell[BoxData[
    \({ReadProtected}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["The function to be substituted", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "This function call generates the proper form for the function to be \
assumed. The symbols in ",
  StyleBox["CoeffList",
    FontWeight->"Bold"],
  " are the names of the coefficients which are to appear in the assumed \
solution. The ",
  Cell[BoxData[
      \(i\^th\)]],
  " name in the list names the coefficients of a series having the form  \n\t\
\t",
  StyleBox["CoeffList[[i]][k] x^(k+r) + Log[x]^(i-1)",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  ". \n\n",
  StyleBox[
  "The length of the list in the third parameter determines how many \
Log-power terms occur",
    FontVariations->{"Underline"->True}],
  ". \n\n",
  StyleBox["CoeffList",
    FontWeight->"Bold"],
  " containing a single entry denotes x^r times a simple power series. If \
r=0, x^r===1.\n\nSide-effects: ",
  StyleBox["CoefficientNames ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "is defined globally for subsequent use. The symbol \[Omega] is used \
instead of \[Infinity] as an upper limit because \[Infinity] introduces \
special problems which using \[Omega] avoids. "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(Clear[y, r, t, a, b, c, d, e]\)], "Input",
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(y[x_] = MakeAssumedFunction[x, r, {a}]\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[BoxData[
    \(\[Sum]\+\(k = 0\)\%\[Omega] x\^\(k + r\)\ a[k]\)], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Substitute y[x] into the operator Op[x, y]", "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(Clear[FormalSeriesResult]\), "\n", 
    \(FormalSeriesResult[x_] = ReleaseHold[Op[x, y]]\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \(3\ x\^2\ \(\[Sum]\+\(k = 0\)\%\[Omega]\((\(-1\) + k + r)\)\ \((k + 
                r)\)\ x\^\(\(-2\) + k + r\)\ a[k]\) + \((\(-x\) + 
            x\^2)\)\ \(\[Sum]\+\(k = 0\)\%\[Omega]\((k + 
                r)\)\ x\^\(\(-1\) + k + r\)\ a[k]\) + \((1 + 
            2\ x)\)\ \(\[Sum]\+\(k = 0\)\%\[Omega] x\^\(k + r\)\ a[
              k]\)\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Manipulate the Formal Series"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Convert the form of each series or Log series so that zero can be imposed \
by the proper choice of the series coefficients. Remove the factor  x^r. Our \
goal is to force each component in  ",
  StyleBox["FormalPowerSeries ",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  "to be identically zero. This creates a recursion relation for each \
component. \n\nThe coefficients of the Log series in decreasing powers occur \
before the power series. The power series is always the last (or only) \
component."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(FormalPowerSeries = \ MakeFormalPowerSeries\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({\[Sum]\+\(k = 0\)\%\[Omega] x\^k\ a[
              k] + \[Sum]\+\(k = 0\)\%\[Omega]\(-\((k + r)\)\)\ x\^k\ a[
              k] + \[Sum]\+\(k = 0\)\%\[Omega] 
            3\ \((\(-1\) + k + r)\)\ \((k + r)\)\ x\^k\ a[
              k] + \[Sum]\+\(k = 0\)\%\[Omega] 
            2\ x\^\(1 + k\)\ a[
              k] + \[Sum]\+\(k = 0\)\%\[Omega]\((k + r)\)\ x\^\(1 + k\)\ a[
              k]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Determining Set"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Generate the determining set. Look in the recursion relation(s) for the \
properties that it predicts. If there are Log series present, the determining \
set describes the (homogeneous) recursion relation of the coefficients of the \
highest log power. In subsequent recursion relations, the correct form is \
predicted, except that the recursion relation is nonhomogeneous. Look for \
this later."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["DeterminingSet = MakeDeterminingSet", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({0, 1}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The final series form"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Combine the series in each component into a single sum with some extra \
terms left over. The coefficient of the term of lowest degree in the first \
component, when set to zero, is the ",
  StyleBox["Indicial Equation",
    FontWeight->"Bold"],
  ", from which the indices are obtained.\n\nNote that ",
  StyleBox["subMax",
    FontWeight->"Bold"],
  " and ",
  StyleBox["subMin",
    FontWeight->"Bold"],
  " are Global variables."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(finalSeries = MakeFinalSeries\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({a[0] - r\ a[0] + 
        3\ \((\(-1\) + r)\)\ r\ a[
            0] + \[Sum]\+\(k = 1\)\%\[Omega] x\^k\ \((\((1 + k + 
                      r)\)\ a[\(-1\) + k] + \((\(-1\) + k + r)\)\ \((\(-1\) + 
                      3\ k + 3\ r)\)\ a[k])\)}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Recursion Relation(s)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Here are the recursion relations for each of the components. The first \
relation determines the coefficients of the highest power Log series. Each \
subsequent relation determines the coefficients of a lower power Log series. \
The last (or only) relation determines the power series coefficients."], 
  "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["RecursionRelation = MakeRecursionRelation", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({{\((1 + k + r)\)\ a[\(-1\) + k] + \((\(-1\) + k + r)\)\ \((\(-1\) + 
                  3\ k + 3\ r)\)\ a[k] == 0, 
        k \[GreaterEqual] 1}}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Initial Equations"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "These are the equations that are not explicitly generated by the recursion \
relation(s). The very first one is the ",
  StyleBox["Indicial Equation",
    FontWeight->"Bold"],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell["InitialEquations = MakeInitialEquations", "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({a[0] - 4\ r\ a[0] + 3\ r\^2\ a[0] == 0}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The Indices"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "Solve the ",
  StyleBox["Indicial Equation",
    FontWeight->"Bold"],
  " to get the indices."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(IndicialEquation = Take[InitialEquations, {1}]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({a[0] - 4\ r\ a[0] + 3\ r\^2\ a[0] == 0}\)], "Output"]
}, Closed]],

Cell[TextData[{
  StyleBox["Manually make an adjustment to the left hand side below",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  ", depending on the order of ",
  StyleBox["IndicialEquation",
    FontFamily->"Courier",
    FontWeight->"Bold"],
  " as a polynomial in r. One simple way is to execute the cell once, and \
then adjust so the number of named indices ",
  StyleBox["{r1 ,r2, ...}",
    FontWeight->"Bold"],
  " matches the number of roots.\n\n",
  StyleBox["If the indicial equation",
    FontVariations->{"Underline"->True}],
  " is always ",
  StyleBox["True",
    FontWeight->"Bold"],
  " (as it may be for series centered on an ordinary point), set ",
  StyleBox["r1=0",
    FontWeight->"Bold"],
  " and do not execute the next cell. Then do not use r2."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \({r1, r2} = r /. Solve[IndicialEquation, r]\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[BoxData[
    \({1\/3, 1}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Equate Coefficients to 0 (Using n=5)"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Choose the number of terms you want in this boxed cell:"], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(n = 5;\)\)], "Input",
  CellFrame->True,
  AspectRatioFixed->True,
  Background->RGBColor[0.936004, 1, 0.680003]],

Cell[TextData[
"Now that we know the number of coefficients we need to determine, we can \
generate the equations that will be used to determine them and the list of \
unknowns in the required order (back to front)."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(\(EquationList[r_] = 
        Join[InitialEquations, 
          Table[AllRecursionRelations[k, r], {k, subMax, n}]];\)\(\n\)
    \)\), "\n", 
    \(TheCoefficients = 
      Join @@ \(\((Table[#1[n - subMin - j], {j, 0, n - subMin}] &)\) /@ 
          Reverse[CoefficientNames]\)\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    \({a[5], a[4], a[3], a[2], a[1], a[0]}\)], "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["The first series solution"], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[
"Use the first index to generate (one or more) solutions. Here is where you \
have to be particularly observant. Often two indices will generate the same \
series. Watch carefully for this!  If, after using every index, you still are \
missing some solutions, go back and recalculate with more Log series terms. \
Do this by appending another symbol in the third component of the function \
that generates the assumed function y[x]. Eventually you will get a full \
complement of linearly independent solutions."], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(y1[x_] = MakeSeriesSolution[r1] + O[x]^\((n + 2)\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(a[0]\ x\^\(1/3\)\), "-", \(7\/3\ a[0]\ x\^\(4/3\)\), 
        "+", \(35\/36\ a[0]\ x\^\(7/3\)\), 
        "-", \(65\/324\ a[0]\ x\^\(10/3\)\), 
        "+", \(13\/486\ a[0]\ x\^\(13/3\)\), 
        "-", \(\(19\ a[0]\ x\^\(16/3\)\)\/7290\), "+", 
        InterpretationBox[\(O[x]\^7\),
          SeriesData[ x, 0, {}, 1, 21, 3]]}],
      SeriesData[ x, 0, {
        a[ 0], 0, 0, 
        Times[ 
          Rational[ -7, 3], 
          a[ 0]], 0, 0, 
        Times[ 
          Rational[ 35, 36], 
          a[ 0]], 0, 0, 
        Times[ 
          Rational[ -65, 324], 
          a[ 0]], 0, 0, 
        Times[ 
          Rational[ 13, 486], 
          a[ 0]], 0, 0, 
        Times[ 
          Rational[ -19, 7290], 
          a[ 0]]}, 1, 21, 3]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell["Check", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[Op[x, y1]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(-\(\(209\ a[0]\ x\^\(19/3\)\)\/10935\)\), "+", 
        InterpretationBox[\(O[x]\^7\),
          SeriesData[ x, 0, {}, 19, 21, 3]]}],
      SeriesData[ x, 0, {
        Times[ 
          Rational[ -209, 10935], 
          a[ 0]]}, 19, 21, 3]]], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[
"A second series solution (when r2 != r1) - if needed."], "Section",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(FixSum\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(y2[x_] = MakeSeriesSolution[r2] + O[x]^\((n + 2)\)\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[
      RowBox[{\(a[0]\ x\), "-", \(3\/5\ a[0]\ x\^2\), 
        "+", \(3\/20\ a[0]\ x\^3\), "-", \(1\/44\ a[0]\ x\^4\), 
        "+", \(\(3\ a[0]\ x\^5\)\/1232\), "-", \(\(3\ a[0]\ x\^6\)\/14960\), 
        "+", 
        InterpretationBox[\(O[x]\^7\),
          SeriesData[ x, 0, {}, 1, 7, 1]]}],
      SeriesData[ x, 0, {
        a[ 0], 
        Times[ 
          Rational[ -3, 5], 
          a[ 0]], 
        Times[ 
          Rational[ 3, 20], 
          a[ 0]], 
        Times[ 
          Rational[ -1, 44], 
          a[ 0]], 
        Times[ 
          Rational[ 3, 1232], 
          a[ 0]], 
        Times[ 
          Rational[ -3, 14960], 
          a[ 0]]}, 1, 7, 1]]], "Output"]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData["Check second solution"], "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[CellGroupData[{

Cell[BoxData[
    \(Expand[Op[x, y2]]\)], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    InterpretationBox[\(O[x]\^7\),
      SeriesData[ x, 0, {}, 7, 7, 1]]], "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Implementation (Initialization Cells) ", "Section",
  Evaluatable->False,
  InitializationCell->True,
  AspectRatioFixed->True,
  FontColor->RGBColor[0, 0, 1]],

Cell["\<\
Unprotect[Sum];
FixSum:=ClearAttributes[Sum,HoldAll];\
\>", "Input",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["Define Standard form of operator", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
SetAttributes[StandardOperatorForm, HoldAll]; 
StandardOperatorForm[(L_)[x_, v_]] := 
  L[x, v] /. Derivative[p_][v][x] :> HoldForm[D[v[x], {x, p}]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Define Assumed Function", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Clear[MakeAssumedFunction]; 
MakeAssumedFunction[x_, r1_:0, CoeffList_List] := 
  Module[{n = Length[CoeffList],r = r1, i,s}, 
  \tOff[Part::pspec];Off[General::spell1];
   CoefficientNames = CoeffList; 
   s=Sum[(CoeffList[[i]][k])*x^(k+r)*Log[x]^(i-1), \t
   \t\t{i,1,Max[n, 1]}];
   \tOn[Part::pspec];On[General::spell1];
   If[TrueQ[Head[s]==Plus],Map[Sum[#,{k,0,\[Omega]} ]&,s],
   \t\tSum[s,{k,0,\[Omega]}]]
   ]
   \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Define Function which Makes Series Solutions", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell["\<\
Clear[MakeSeriesSolution]; 
MakeSeriesSolution[r_] := 
  Module[{rootRules}, Off[Solve::svars];
  rootRules = 
     Solve[Flatten[EquationList[r]],
     \tTheCoefficients, Sort -> False]; 
  On[Solve::svars];
  MakeAssumedFunction[x, r, CoefficientNames]/.\[Omega]\[Rule]n-subMin \
/.rootRules[[1]]]\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[BoxData[
    \(MakeFormalPowerSeries := 
      Module[{LogStep1, LogStep2, LogStep3, TheLogParts, step0, step1}, 
        LogStep1 = FormalSeriesResult[x] //. RemoveLogPowers; 
        LogStep2 = LogStep1 //. RemoveSimpleLog; 
        LogStep3 = LogStep2 //. ToIndividualSums; 
        TheLogParts = Reverse[CoefficientList[LogStep3, t]]; 
        step0 = TheLogParts /. RemoveFactor[x, r]; 
        step1 = step0 //. RemoveZeroTerms; 
        step1 //. IncorporateFactors]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeFinalSeries := 
      Module[{step3, step4, step5, step6, step7, step8}, 
        subMax = Max[DeterminingSet]; subMin = Min[DeterminingSet]; 
        step3 = FormalPowerSeries //. AdjustIndices; 
        step4 = step3 /. EqualizeInitialIndices[subMax]; 
        step5 = step4 //. CombineSeries; 
        step6 = step5 /. CollectInitialTerms[x]; 
        step7 = step6 //. CollectSeriesTerms; 
        step8 = step7 //. CollectCoefficientTerms; 
        step8 //. FactorCoefficientTerms]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeDeterminingSet\  := \ \n\ \ Module[{}, \ 
        StepsToList\  = \ \n\ \ \ \ \ Flatten[
            FormalPowerSeries\  //. \ \n\ \ \ \ \ \ \ Plus[
                  Sum[c_, \ {k_, \ 
                        s_, \ \[Omega]}]\  + \ \((e_)\)]\  :> \ \n\ \ \ \ \ \ \
\ \ {Sum[c, \ {k, \ s, \ \[Omega]}], \ e}]; \ \n\ \ \ \ Union[
          StepsToList\  //. \ \n\ \ \ \ \ \ Sum[\((a_. )\)*
                  x^\((\((k_)\)\  + \ \((p_. )\))\), \ {k, \ 
                  s_, \ \[Omega]}]\  :> \ p]\n]\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeRecursionRelation\  := \ \n\ \ finalSeries\  /. \ \n\ \ \ \((p_)\)\ \
 + \ Sum[\((c_)\)*\((x_)\)^\((k_)\), \ {k_, \ 
                s_, \ \[Omega]}]\  :> \ \n\ \ \ \ {c\  == \ 0, \ 
            k\  >= \ s}\)], "Input",
  InitializationCell->True],

Cell[BoxData[
    \(MakeInitialEquations\  := \ \n\ \ Module[{InitialTerms}, \ \n\ \ \ \
AllRecursionRelations[k_, \ 
            r_]\  = \ \n\ \ \ \ \ \(Transpose[
              RecursionRelation]\)[\([1]\)]; \ \n\ \ \ \ InitialTerms\  = \ \n\
\ \ \ \ \ Expand[\((finalSeries\  /. \ \n\ \ \ \ \ \ \ \ \ \((p_)\)\  + \ 
                      Sum[\((c_)\)*\((x_)\)^\((k_)\), \ \n\ \ \ \ \ \ \ \ \ \ \
\ \ {k_, \ s_, \ \[Omega]}]\  :> \ p)\)/
              x^subMin]; \ \n\ \ \ \ \((#1\  == \ 
                0\  &\ )\)\  /@ \ \n\ \ \ \ \ Flatten[
            CoefficientList[InitialTerms, \ x]]]\)], "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Transformation Rules", "Subsection",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(AdjustIndices\  = \ \n\ \ \ Sum[\((c_)\)*\((x_)\)^\((\((k_)\)\  + \ \
\((q_)\))\), \ {k_, \ 
              s_, \ \[Omega]}]\  :> \ \n\ \ \ \ Sum[\((c\  /. \ 
                  k\  :> \ k\  - \ q)\)*x^k, \ {k, \ 
              s\  + \ q, \ \[Omega]}];\)\(\ \)\)\)], "Input",
  InitializationCell->True],

Cell["\<\
RemoveLogPowers = 
   (a_.)*Sum[(p1_)*Log[x_]^(q_) + (p2_.), {k_, s_, \[Omega]}] :> 
    a*t^q*Sum[p1, {k, s, \[Omega]}] + a*Sum[p2, {k, s, \[Omega]}]; \
\>", \
"Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
RemoveSimpleLog = 
   (a_.)*Sum[(p1_)*Log[x_] + (p2_.), {k_, s_, \[Omega]}] :> 
    a*t*Sum[p1, {k, s, \[Omega]}] + a*Sum[p2, {k, s, \[Omega]}]; \
\>", \
"Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
ToIndividualSums = 
   (a_.)*Sum[(p1_) + (p2_), {k_, s_, \[Omega]}] :> 
    a*Sum[p1, {k, s, \[Omega]}] + a*Sum[p2, {k, s, \[Omega]}]; \
\>", "Input",\

  InitializationCell->True,
  AspectRatioFixed->True],

Cell["RemoveFactor[x_, r_] = x^((p_) + r) :> x^p; ", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
RemoveZeroTerms = 
   Sum[(c_)*(x_)^(p_), {k_, a_, \[Omega]}] :> 
    Sum[c*x^p, {k, a + 1, \[Omega]}] /; (c /. k -> a) == 0; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
IncorporateFactors = 
   ((a_.) + (b_))*Sum[c_, {k_, s_, \[Omega]}] :> 
    Sum[a*c, {k, s, \[Omega]}] + Sum[b*c, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
Clear[EqualizeInitialIndices]
EqualizeInitialIndices[subMax_] := 
  Sum[c_, {k_, s_, \[Omega]}] :> 
   Sum[c, {k, s, subMax - 1}] + Sum[c, {k, subMax, \[Omega]}] /; s < subMax\
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CombineSeries = 
   Sum[c_, {k_, s_, \[Omega]}] + Sum[d_, {k_, s_, \[Omega]}] :> 
    Sum[c + d, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectInitialTerms[x_] = 
   (p_) + Sum[c_, {k_, s_, \[Omega]}] :> 
    Collect[p, x] + Sum[c, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectSeriesTerms = 
   Sum[(x_)^(k_)*(c1_.) + (x_)^(k_)*(d1_.) + (e1_.), {k_, s_, \[Omega]}] :> 
    Sum[x^k*(c1 + d1) + e1, {k, s, \[Omega]}]; \
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
CollectCoefficientTerms = 
   Sum[(x_)^(k_)*((c1_.)*(c_)[p_] + (d1_.)*(c_)[p_] + (e1_.)), 
     {k_, s_, \[Omega]}] :> Sum[x^k*((c1 + d1)*c[p] + e1), {k, s, \[Omega]}]; \
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell["\<\
FactorCoefficientTerms = 
   Sum[((c1_)*(c_)[p_] + (c2_)*(c_)[q_] + (c3_.))*x^k, {k_, s_, \[Omega]}] :> \

    Sum[(Factor[c1]*c[p] + Factor[c2]*c[q] + c3)*x^k, {k, s, \[Omega]}]; \
\
\>", "Input",
  InitializationCell->True,
  AspectRatioFixed->True]
}, Closed]]
}, Closed]]
}, Open  ]]
},
FrontEndVersion->"4.2 for Macintosh",
ScreenRectangle->{{4, 1024}, {0, 746}},
AutoGeneratedPackage->None,
WindowToolbars->{},
CellGrouping->Automatic,
WindowSize->{591, 660},
WindowMargins->{{23, Automatic}, {Automatic, 10}},
PrivateNotebookOptions->{"ColorPalette"->{RGBColor, 128}},
ShowCellLabel->True,
ShowCellTags->False,
RenderingOptions->{"ObjectDithering"->True,
"RasterDithering"->False},
CharacterEncoding->"MacintoshAutomaticEncoding"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 178, 7, 95, "Subtitle",
  Evaluatable->False],
Cell[1957, 62, 207, 5, 59, "Text"],
Cell[2167, 69, 757, 18, 158, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[2949, 91, 117, 2, 56, "Section",
  Evaluatable->False],
Cell[3069, 95, 556, 11, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3650, 110, 104, 2, 46, "Subsection",
  Evaluatable->False],
Cell[3757, 114, 179, 6, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[3961, 124, 538, 14, 47, "Input"],
Cell[4502, 140, 397, 9, 29, "Output"]
}, Closed]],
Cell[4914, 152, 403, 11, 68, "Text"],

Cell[CellGroupData[{
Cell[5342, 167, 90, 2, 43, "Input"],
Cell[5435, 171, 49, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[5533, 178, 100, 2, 46, "Subsection",
  Evaluatable->False],
Cell[5636, 182, 1153, 32, 212, "Text",
  Evaluatable->False],
Cell[6792, 216, 88, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[6905, 222, 163, 4, 43, "Input"],
Cell[7071, 228, 80, 1, 50, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7212, 236, 109, 2, 36, "Section",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[7346, 242, 149, 3, 43, "Input"],
Cell[7498, 247, 375, 6, 94, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[7922, 259, 105, 2, 36, "Section",
  Evaluatable->False],
Cell[8030, 263, 593, 13, 122, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[8648, 280, 102, 2, 27, "Input"],
Cell[8753, 284, 425, 8, 94, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9227, 298, 92, 2, 36, "Section",
  Evaluatable->False],
Cell[9322, 302, 472, 8, 86, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[9819, 314, 78, 1, 27, "Input"],
Cell[9900, 317, 40, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[9989, 324, 98, 2, 36, "Section",
  Evaluatable->False],
Cell[10090, 328, 512, 15, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[10627, 347, 88, 2, 27, "Input"],
Cell[10718, 351, 279, 5, 76, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11046, 362, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[11151, 366, 376, 7, 68, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[11552, 377, 84, 1, 27, "Input"],
Cell[11639, 380, 179, 3, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[11867, 389, 94, 2, 36, "Section",
  Evaluatable->False],
Cell[11964, 393, 260, 8, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12249, 405, 82, 1, 27, "Input"],
Cell[12334, 408, 74, 1, 29, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[12457, 415, 88, 2, 36, "Section",
  Evaluatable->False],
Cell[12548, 419, 173, 7, 32, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[12746, 430, 105, 2, 27, "Input"],
Cell[12854, 434, 74, 1, 29, "Output"]
}, Closed]],
Cell[12943, 438, 848, 24, 122, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[13816, 466, 167, 4, 43, "Input"],
Cell[13986, 472, 43, 1, 42, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[14078, 479, 113, 2, 36, "Section",
  Evaluatable->False],
Cell[14194, 483, 130, 3, 32, "Text",
  Evaluatable->False],
Cell[14327, 488, 135, 4, 43, "Input"],
Cell[14465, 494, 274, 5, 50, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[14764, 503, 341, 8, 107, "Input"],
Cell[15108, 513, 70, 1, 27, "Output"]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[15227, 520, 102, 2, 36, "Section",
  Evaluatable->False],
Cell[15332, 524, 585, 9, 104, "Text",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[15942, 537, 109, 2, 27, "Input"],
Cell[16054, 541, 808, 25, 79, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[16899, 571, 75, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[16999, 577, 76, 2, 27, "Input"],
Cell[17078, 581, 306, 8, 45, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[17445, 596, 131, 3, 36, "Section",
  Evaluatable->False],
Cell[17579, 601, 39, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[17643, 606, 109, 2, 27, "Input"],
Cell[17755, 610, 723, 24, 45, "Output"]
}, Closed]],

Cell[CellGroupData[{
Cell[18515, 639, 101, 2, 46, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[18641, 645, 76, 2, 27, "Input"],
Cell[18720, 649, 98, 2, 29, "Output"]
}, Closed]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[18879, 658, 165, 4, 36, "Section",
  Evaluatable->False,
  InitializationCell->True],
Cell[19047, 664, 106, 4, 42, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[19178, 672, 102, 2, 46, "Subsection",
  Evaluatable->False],
Cell[19283, 676, 227, 6, 72, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[19547, 687, 93, 2, 30, "Subsection",
  Evaluatable->False],
Cell[19643, 691, 501, 15, 207, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[20181, 711, 114, 2, 30, "Subsection",
  Evaluatable->False],
Cell[20298, 715, 378, 12, 147, "Input",
  InitializationCell->True],
Cell[20679, 729, 519, 10, 203, "Input",
  InitializationCell->True],
Cell[21201, 741, 552, 11, 187, "Input",
  InitializationCell->True],
Cell[21756, 754, 562, 10, 139, "Input",
  InitializationCell->True],
Cell[22321, 766, 271, 5, 75, "Input",
  InitializationCell->True],
Cell[22595, 773, 636, 11, 171, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[23268, 789, 90, 2, 30, "Subsection",
  Evaluatable->False],
Cell[23361, 793, 325, 6, 59, "Input",
  InitializationCell->True],
Cell[23689, 801, 233, 7, 87, "Input",
  InitializationCell->True],
Cell[23925, 810, 226, 7, 72, "Input",
  InitializationCell->True],
Cell[24154, 819, 216, 7, 57, "Input",
  InitializationCell->True],
Cell[24373, 828, 115, 2, 27, "Input",
  InitializationCell->True],
Cell[24491, 832, 205, 6, 72, "Input",
  InitializationCell->True],
Cell[24699, 840, 212, 6, 57, "Input",
  InitializationCell->True],
Cell[24914, 848, 256, 8, 87, "Input",
  InitializationCell->True],
Cell[25173, 858, 195, 6, 57, "Input",
  InitializationCell->True],
Cell[25371, 866, 194, 6, 57, "Input",
  InitializationCell->True],
Cell[25568, 874, 225, 6, 72, "Input",
  InitializationCell->True],
Cell[25796, 882, 250, 7, 87, "Input",
  InitializationCell->True],
Cell[26049, 891, 261, 8, 87, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

osed]]
}, Closed]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

